% generate the raw data FOR independent CASE in our paper
% d- sample rate (d out of 10)
% n-subjects
% L-the total numbers of observations for each subject, 
%i.e. the time units is 1/L in our paper
function [y,x]=rawdata_quality(n,d,L)
J=L/10;%generate J observation for each subject
x=zeros(d*J,n,100);
y=zeros(d*J,n,100);
e=zeros(d*J,n,100);
for j=1:100
for k=1:n
for i=1:J
%randomly select d time points out of 10 time points
    A=randperm(10);
    B(((i-1)*d+1):((i-1)*d+d))=(i-1)*10+sort(A(1:d));
end
x(1:d*J,k,j)=B./L';
y(1:d*J,k,j)=1+0.3.*(B'./L).^0.5;
e(1:d*J,k,j)=mvnrnd(zeros(d*J,1),diag(y(1:d*J,k,j)).^2);
y(1:d*J,k,j)=y(1:d*J,k,j)+e(1:d*J,k,j);
end
end
x1=x;y1=y;
 save(['C:\2012-06-20\2012-06-20-1\2012-06-20-1\U of M\quality\rawdataic_for_univariate_spc_',num2str(L),'_00n',num2str(n),'_J',num2str(d*J),'.mat'],'y1','x1')
